package ru.yandex.tours.indexer.hotels

import ru.yandex.tours.geo
import ru.yandex.tours.geo.base.region
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.resorts.SkiResorts

import scala.collection.JavaConverters._

class SlopeDistanceEnricher(slopes: Slopes, skiResorts: SkiResorts, tree: region.Tree) {

  val SLOPE_DISTANCE_ENUM = "slope_distance_enum"
  val DISTANCE_SLOPES = "distance_slopes"
  val DEFAULT_NEAR_SKI_RESORT_MAX_DISTANCE_IN_KM = 100

  def enrich(builder: PartnerHotel.Builder) {
    if (!builder.getRawHotel.hasPoint) return

    val point = builder.getRawHotel.getPoint

    var nearSkiResort = false
    for {
      resort <- skiResorts.resorts
      region <- tree.region(resort.ski.id)
      dist = geo.distanceInKm(region, point)
      if dist < resort.ski.nearDistance.getOrElse(DEFAULT_NEAR_SKI_RESORT_MAX_DISTANCE_IN_KM)
    } {
      nearSkiResort = true
    }

    val features = for {
      feature <- builder.getRawHotel.getFeaturesList.asScala
      if feature.getName != SLOPE_DISTANCE_ENUM
      if feature.getName != DISTANCE_SLOPES
    } yield feature

    builder.getRawHotelBuilder.clearFeatures().addAllFeatures(features.asJava)

    if (!nearSkiResort) return

    slopes.getSlopeDistance(point.getLatitude, point.getLongitude).foreach { distance =>
      builder.getRawHotelBuilder.addFeaturesBuilder().setName(DISTANCE_SLOPES).setValue(distance.toString)
      (distance match {
        case x if x < 50 => Some("0")
        case x if x < 250 => Some("250")
        case x if x < 500 => Some("500")
        case x if x < 1000 => Some("1000")
        case x if x < 1500 => Some("1500")
        case x if x < 3000 => Some("3000")
        case _ => None
      }).foreach { enum =>
        builder.getRawHotelBuilder.addFeaturesBuilder().setName(SLOPE_DISTANCE_ENUM).setValue(enum)
      }
    }
  }
}
