package ru.yandex.tours.indexer.hotels.parsers

import ru.yandex.tours.model.hotels.Partners

class OktogoFormatParser extends CommonFormatParser(
  partner = Partners.oktogo,
  regionParam = Some("PrimaryLocationID"),
  featureMappings = OktogoFormatParser.featureMappings
)

object OktogoFormatParser {
  private val featureMappings: PartialFunction[(String, String), (String, String)] = {
    case ("turkish_bath", "true") => ("steam", "turkish_bath")
    case ("bike_rental", "true") => ("rental", "rent_a_bike")
    case ("restourant", "true") => ("has_restaurant", "true")
    case ("pingpong", "true") => ("table_tennis", "true")
    case ("bar", "true") => ("has_bar", "true")
    case ("free_parking", "true") => ("type_parking", "free_parking")
    case ("ironing_board", "true") => ("ironing", "true")
    case ("nonsmoking", "true") => ("type_rooms", "non_smoking_room")
    case ("horse_riding", "true") => ("riding", "true")
    case ("tv", "true") => ("tv_set", "true")
    case ("indoor_pool", "true") => ("pool_type", "indoor_pool")
    case ("secure_parking", "true") => ("type_parking", "guarded_parking")
    case ("pets_allowed", "true") => ("pets", "true")
    case ("ski_rental", "true") => ("rental", "ski_hire")
    case ("golf", "true") => ("area_golf", "true")
    case ("foreign_exchange", "true") => ("currency_exchange", "true")
    case ("shoe/clothing_repair", "true") => ("clothes_and_shoe_repairs", "repair_clothing_and_footwear")
    case ("satellite_tv", "true") => ("tv", "satellite_tv")
    case ("business_centre", "true") => ("business_center", "true")
    case ("paid_parking", "true") => ("type_parking", "paid_parking")
    case ("car_rental", "true") => ("rental", "rent_a_car")
    case ("massage", "true") => ("massage_services", "true")
    case ("coffee_machine", "true") => ("coffee_maker", "true")
    case ("24hours__reception", "true") => ("24_front_desk", "true")
    case ("luggage_room", "true") => ("left_luggage_office", "luggage")
    case ("phone", "true") => ("telephone", "true")
    case ("air_conditioneer", "true") => ("air_conditioning", "true")
    case ("hair_dryer_in_the_room", "true") => ("hair_dryer", "true")
    case ("shopping", "true") => ("shops", "true")
    case ("free_wifi", "true") => ("internet_in_hotel", "free_wi_fi_in_public_areas")
    case ("parking_by_request", "true") => ("type_parking", "advance_booking_parking")
    case ("drycleaning", "true") => ("dry_cleaning", "true")
    case ("russian_bath", "true") => ("steam", "russian_sauna")
    case ("iron", "true") => ("ironing", "true")
    case ("allergy_friendly", "true") => ("type_rooms", "room_allergic")
    case ("own_beach", "true") => ("private_beach", "true")
    case ("disability_friendly", "true") => ("room_disabled", "true")
  }
}
