package ru.yandex.tours.indexer.hotelscombined

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.partners.MappedHotelsCombinedId2Key
import ru.yandex.tours.util.IO

import scala.collection.JavaConverters._
import scala.collection.mutable
import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

/**
  * Created by asoboll on 16.12.16.
  */
class HCId2KeyIndexer(dataPersistenceManager: DataPersistenceManager,
                      hotelsDao: HotelsDao,
                      duration: FiniteDuration)
                     (implicit ex: ExecutionContext)
  extends AsyncUpdatable(duration, "hc_id2key_indexer") with TaskWeight.Medium {

  override protected def update: Future[_] = {
    val id2key = mutable.ArrayBuffer.empty[(String, String)]

    hotelsDao.traverse(
      HotelsDao.OnlyPartner(Partners.hotelsCombined),
      HotelsDao.SkipDeleted
    ) { hotel =>
      val rawHotel = hotel.hotel.getRawHotel
      for {
        feature <- rawHotel.getAddInfoList.asScala.find(_.getName == "HotelKey")
      } id2key += rawHotel.getPartnerId -> feature.getValue
    }.map { _ =>
      val is = IO.writeStream(MappedHotelsCombinedId2Key.writeTo(_, id2key))
      dataPersistenceManager.checkAndStore(DataTypes.hcId2Key, is)
    }
  }
}
