package ru.yandex.tours.indexer.ota

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.ota.OnlineTourAgency
import ru.yandex.tours.ota.OnlineTourAgencies
import ru.yandex.tours.util.http.AsyncHttpClient

import scala.concurrent.ExecutionContext
import scala.concurrent.duration.FiniteDuration

class OtaHotelIndexer(agencies: OnlineTourAgencies,
                      hotelsIndex: HotelsIndex,
                      updateTime: FiniteDuration,
                      client: AsyncHttpClient,
                      extDataService: ExtDataService,
                      dataPersistenceManager: DataPersistenceManager)
                     (implicit ec: ExecutionContext)
  extends OtaIndexer(agencies, updateTime, client, extDataService, dataPersistenceManager, "ota_hotels") {

  override protected def dataType: DataType = DataTypes.otaHotelMappings

  override protected def processId(ota: OnlineTourAgency, id: String) = hotelsIndex.getHotel(Partners.lt, id).map(_.id)

  override protected def getUrl(ota: OnlineTourAgency): String = ota.hotelUrl
}
