package ru.yandex.tours.indexer.ota

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.ota.OnlineTourAgency
import ru.yandex.tours.operators.TourOperators
import ru.yandex.tours.ota.OnlineTourAgencies
import ru.yandex.tours.util.http.AsyncHttpClient

import scala.concurrent.ExecutionContext
import scala.concurrent.duration.FiniteDuration

class OtaOperatorIndexer(agencies: OnlineTourAgencies,
                         operators: TourOperators,
                         updateTime: FiniteDuration,
                         client: AsyncHttpClient,
                         extDataService: ExtDataService,
                         dataPersistenceManager: DataPersistenceManager)
                        (implicit ec: ExecutionContext)
  extends OtaIndexer(agencies, updateTime, client, extDataService, dataPersistenceManager, "ota_operators") {

  override protected def dataType = DataTypes.otaOperatorMappings

  override protected def processId(ota: OnlineTourAgency, id: String) = operators.getByCode(Partners.lt, id).map(_.id)

  override protected def getUrl(ota: OnlineTourAgency): String = ota.operatorsUrl
}
