package ru.yandex.tours.indexer.ota

import play.api.libs.json._

object OtaParsers {
  trait Parser {
    def getLtIds(x: String): Iterable[String]

    def getYandexMapping(x: String): Iterable[(Int, String)]
  }

  class StandardParser extends Parser {
    private def getIds[T](json: String, idExtractor: JsValue => Option[T]): Iterable[T]  = {
      Json.parse(json).as[JsArray].value.flatMap(idExtractor(_).toIterable)
    }

    override def getLtIds(x: String): Iterable[String] = getIds(x, obj => { obj \ "ref_id" match {
      case JsString(value) => Some(value)
      case JsNumber(value) => Some(value.toString())
      case _ => None
    }})

    override def getYandexMapping(x: String): Iterable[(Int, String)] = getIds(x, obj => {
      obj \ "ya_ref_id" match {
        case JsNumber(yaId) =>
          val partnerId = obj \ "id" match {
            case JsString(value) => Some(value)
            case JsNumber(value) => Some(value.toString())
            case _ => None
          }
          partnerId.map(yaId.intValue() -> _)
        case _ => None
      }
    })
  }

  class TravelataParser(isCity: Boolean = false) extends Parser {
    private val standardParser = new StandardParser

    override def getLtIds(x: String): Iterable[String] = {
      val fieldName = if (isCity) "city_id" else "id"
      Json.parse(x).as[JsArray].value.map(x => {
        (x \ fieldName).as[String]
      })
    }

    override def getYandexMapping(x: String): Iterable[(Int, String)] = standardParser.getYandexMapping(x)
  }
}
