package ru.yandex.tours.indexer.ota

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.indexer.ota.OtaParsers.{Parser, StandardParser, TravelataParser}
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.ota.OnlineTourAgency
import ru.yandex.tours.ota.OnlineTourAgencies
import ru.yandex.tours.util.http.AsyncHttpClient

import scala.concurrent.ExecutionContext
import scala.concurrent.duration.FiniteDuration

class OtaRegionIndexer(agencies: OnlineTourAgencies,
                       geoMapping: GeoMappingHolder,
                       updateTime: FiniteDuration,
                       client: AsyncHttpClient,
                       extDataService: ExtDataService,
                       dataPersistenceManager: DataPersistenceManager)
                      (implicit ec: ExecutionContext)
  extends OtaIndexer(agencies, updateTime, client, extDataService, dataPersistenceManager, "ota_regions") {

  override protected def dataType: DataType = DataTypes.otaCitiesMappings

  override protected def processId(ota: OnlineTourAgency, id: String) = geoMapping.getGeoIdByCity(Partners.lt, id)

  override protected def getUrl(ota: OnlineTourAgency): String = ota.regionsUrl

  override protected def createParser(ota: OnlineTourAgency): Parser = ota.billingId match {
    case "Travelata" => new TravelataParser(isCity = true)
    case _ => new StandardParser
  }
}
