package ru.yandex.tours.indexer.ratings

import java.io.{FileInputStream, PrintWriter}

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}
import scala.util.Success

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 21.03.16
 */
class PartnerRatingsIndexer(hotelsDao: HotelsDao,
                            dataPersistenceManager: DataPersistenceManager,
                            updateTime: FiniteDuration)
                           (implicit ec: ExecutionContext)
  extends AsyncUpdatable(updateTime, "hotel_partner_ratings") with TaskWeight.Medium {

  override protected def update: Future[_] = {
    val file = IO.newTempFile("partner-ratings-indexer")
    IO.usingAsync(new PrintWriter(file)) { pw =>
      hotelsDao.traverseAll { hotel =>
        if (hotel.hotel.getRawHotel.getRating > 0) {
          pw.println(Tabbed(
            hotel.id,
            hotel.hotel.getRawHotel.getRating,
            0
          ))
        }
      }
    }.andThen {
      case Success(_) =>
        dataPersistenceManager.checkAndStore(DataTypes.hotelPartnerRatings, new FileInputStream(file))
    }.andThen {
      case _ => file.delete()
    }
  }
}
