package ru.yandex.tours.indexer.ratings

import java.io.InputStream

import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{DoubleValue, IntValue, Tabbed}

import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 11.09.15
 */
class PartnerRatingsParser(hotelsIndex: HotelsIndex) {
  def process(is: InputStream): InputStream = IO.printStream { writer =>
    Source.fromInputStream(is).getLines().foreach {
      case Tabbed(IntValue(partnerId), hotel, DoubleValue(rating)) =>
        hotelsIndex.getHotel(Partners(partnerId), hotel).foreach { hotel =>
          writer.println(Tabbed(
            hotel.id,
            rating,
            0
          ))
        }
    }
  }
}
