package ru.yandex.tours.indexer.regions

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.db.{CustomRegions, DBWrapper}
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.geo.base.custom.CustomRegion
import ru.yandex.tours.geo.base.export.{RegionsXmlWriter, XmlParser}
import ru.yandex.tours.geo.base.region.RegionBoundaries
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.util.IO
import slick.driver.MySQLDriver.api._

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.11.15
 */
class GeobasePatcher(db: DBWrapper,
                     regionBoundaries: RegionBoundaries,
                     extDataService: ExtDataService,
                     dataPersistenceManager: DataPersistenceManager)
                    (implicit ec: ExecutionContext)
  extends AsyncUpdatable(10.minutes, DataTypes.regions.getName) with TaskWeight.Light {

  db.createIfNotExists(CustomRegions.table)

  override protected def update: Future[_] = {
    val tree = XmlParser.parse(
      extDataService.readData(DataTypes.geobase),
      regionBoundaries
    ).get

    for (customRegions <- db.run(CustomRegions.table.result.transactionally)) yield {
      val newTree = CustomRegion.apply(tree, customRegions)

      val is = IO.printStream { writer =>
        val xmlWriter = new RegionsXmlWriter(writer)
        for (region <- newTree.regions) {
          xmlWriter.write(region)
        }
        xmlWriter.close()
      }

      dataPersistenceManager.checkAndStore(DataTypes.regions, is)
    }
  }
}
