package ru.yandex.tours.indexer.searchmapping

import play.api.libs.json.Json
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.db.{CustomRegions, DBWrapper, SearchSettings}
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.model.search.settings.{SearchSettingsRecord, Parameters => SCParameters}
import ru.yandex.tours.util.{IO, Logging}
import slick.driver.MySQLDriver.api._

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration._

/**
  * Created by Evgeny Zhoga on 01.02.16.
  */
class SearchSettingsIndexer(db: DBWrapper,
                            dataPersistenceManager: DataPersistenceManager)
                           (implicit ec: ExecutionContext)
  extends AsyncUpdatable(10.minutes, DataTypes.searchSettings.getName) with TaskWeight.Light with Logging {

  db.createIfNotExists(SearchSettings.table)

  override protected def update: Future[_] = {
    import ru.yandex.tours.search.settings.RegionSearchSettings.Implicits._

    (for {
      customRegions <- db.run(CustomRegions.table.result.transactionally)
    } yield {
      customRegions.filter(_.isNew).map(_.id).toSet
    }).flatMap { newRegionIds =>
      for ( searchSettingsRecords <- db.run(SearchSettings.table.result.transactionally) ) yield {
        val initialRecords = searchSettingsRecords.map {
          case record if record.parameters.forcedSearchable.isEmpty && newRegionIds.contains(record.regionId) =>
            record.copy(parameters = record.parameters.copy(forcedSearchable = Some(true)))
          case record =>
            record
        }
        val allRecords =
          (newRegionIds -- initialRecords.map(_.regionId)).map { regionId =>
            SearchSettingsRecord(regionId, SCParameters(searchByType = Map.empty, forcedSearchable = Some(true)))
          } ++ initialRecords
        val is = IO.printStream { writer =>
          writer.write(Json.toJson(allRecords).toString())
        }
        dataPersistenceManager.checkAndStore(DataTypes.searchSettings, is)
      }
    }
  }
}
