package ru.yandex.tours.indexer.sitemap

import java.io.File

import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.indexer.export.Exporter
import ru.yandex.tours.indexer.task.TaskWeight
import ru.yandex.tours.resorts.SkiResorts
import ru.yandex.tours.util.s3.S3Client

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class SitemapIndexer(hotelsIndex: HotelsIndex,
                     geoMappingHolder: GeoMappingHolder,
                     skiResorts: SkiResorts,
                     s3Client: S3Client,
                     updateTime: FiniteDuration)
                    (implicit ec: ExecutionContext)
  extends Exporter("sitemap", "sitemap.zip", s3Client, updateTime) with TaskWeight.Medium {

  override protected def generateExport(): Future[File] = Future {
    SitemapGenerator.generate(hotelsIndex, geoMappingHolder, skiResorts)
  }
}
