package ru.yandex.tours.indexer.suggest

import java.io.{PrintWriter, OutputStream}

import ru.yandex.tours.geo.base.region.{Types, Tree}
import ru.yandex.tours.model.{Languages, Agency}
import ru.yandex.tours.util.Logging

object AgencyCitySuggestGenerator extends Logging {
  def generate(agencies: Iterable[Agency], tree: Tree, os: OutputStream) = {
    val geoIds = agencies.map(_.geoId).toSet
    val pw = new PrintWriter(os)
    geoIds.flatMap(tree.region).foreach { region =>
      val country = tree.country(region).get
      val parts = Seq(
        region.name(Languages.ru),
        country.name(Languages.ru),
        region.position,
        region.id,
        region.allNames.mkString(",")
      )
      pw.println(parts.mkString("\t"))
    }
    pw.close()
  }
}
