package ru.yandex.tours.indexer.suggest

import org.apache.commons.io.FileUtils
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.direction.Priorities
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.search.settings.SearchSettingsHolder
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.s3.S3Client
import spray.http.{StatusCode, StatusCodes}

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}
import scala.util.{Failure, Success}

class SuggestIndexer(hotelsIndex: HotelsIndex,
                     geoMapping: GeoMappingHolder,
                     tree: Tree,
                     countryPriorities: Priorities,
                     resortPriorities: Priorities,
                     hotelPriorities: Priorities,
                     searchSettings: SearchSettingsHolder,
                     extDataService: ExtDataService,
                     s3Client: S3Client,
                     updatePeriod: FiniteDuration)
                    (implicit ec: ExecutionContext)
  extends AsyncUpdatable(updatePeriod, "suggest") with TaskWeight.Medium {

  override def update: Future[_] = Future {
    val synonymsIs = extDataService.readData(DataTypes.geoSynonyms)
    SuggestGenerator.generate(
      hotelsIndex.hotels, geoMapping, tree,
      countryPriorities, resortPriorities, hotelPriorities,
      searchSettings, synonymsIs
    )
  }.flatMap { suggestFile =>
    log.info(s"Generated suggest with size = ${FileUtils.byteCountToDisplaySize(suggestFile.length())}")
    s3Client.uploadFile("suggest", suggestFile) andThen {
      case Success((StatusCodes.OK, _)) => log.info(s"Suggest successfully updated to S3")
      case Success((sc, res)) => log.warn(s"Can not upload suggest to S3! Sc is $sc. Response: $res")
      case Failure(e) => log.error(s"Can not upload suggest to S3", e)
    } andThen { case _ =>
      IO.deleteFile(suggestFile)
    }
  }
}
