package ru.yandex.tours.indexer.task

import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.vertis.scheduler.model.Schedule.EverySeconds
import ru.yandex.vertis.scheduler.model.{Payload, Task, TaskDescriptor}

import scala.concurrent.Future
import scala.concurrent.duration.FiniteDuration

trait Periodic {
  def asTask: Task

  def taskWeight: Int
}

abstract class PeriodicUpdatable(updateTime: FiniteDuration, val name: String)
  extends Runnable with Periodic with Logging {

  def run(): Unit

  def asTask: Task = Task(
    TaskDescriptor(name, EverySeconds(updateTime.toSeconds.toInt), taskWeight),
    Payload(this)
  )
}

abstract class AsyncUpdatable(updateTime: FiniteDuration, val name: String) extends Periodic with Logging {
  protected def update: Future[_]

  override def asTask: Task = Task(
    TaskDescriptor(name, EverySeconds(updateTime.toSeconds.toInt), taskWeight),
    Payload.Async(() => update.toUnit)
  )
}