package ru.yandex.tours.indexer.task

/**
  * Created by asoboll on 27.03.17.
  */
object TaskWeight {
  private val LIGHT_WEIGHT = 1
  private val MEDIUM_WEIGHT = 6
  private val HEAVY_WEIGHT = 17
  private val UNIQUE_WEIGHT = 51 // Total weight of running tasks is 100. So, 51 - is weight to run exclusively with high weighted tasks.

  trait Light extends Periodic { override def taskWeight: Int = LIGHT_WEIGHT }
  trait Medium extends Periodic { override def taskWeight: Int = MEDIUM_WEIGHT }
  trait Heavy extends Periodic { override def taskWeight: Int = HEAVY_WEIGHT }
  trait Unique extends Periodic { override def taskWeight: Int = UNIQUE_WEIGHT }
}
