package ru.yandex.tours.indexer.wizard

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.vertis.scheduler.model.Schedule.{EveryHours, EveryMinutes}
import ru.yandex.vertis.scheduler.model.{Payload, Task, TaskDescriptor}

import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.03.15
 */
class IndexScheduler(indexer: Indexer,
                     distributor: ResourceDistributor,
                     dataPersistenceManager: DataPersistenceManager)
  extends ResourceScheduler(indexer, distributor, dataPersistenceManager, "index") {

  def freshIndexTask: Task = Task(
    TaskDescriptor("wizard_fresh", EveryMinutes(1), description = Some("Builds fresh index (20m)")),
    Payload.Sync(() => doFreshResource(20.minutes))
  )

  def longIndexTask: Task = Task(
    TaskDescriptor("wizard_long", EveryHours(1), description = Some("Builds long index (24h)")),
    Payload.Sync(() => doLongResource(24.hours, DataTypes.wizardIndex.count, DataTypes.wizardIndex))
  )
}
