package ru.yandex.tours.indexer.wizard

import java.io.File

import ru.yandex.tours.index.WizardIndexing
import ru.yandex.tours.index.shard.IndexShard
import ru.yandex.tours.util.Metrics
import ru.yandex.tours.wizard.resource.WizardResourceLoader

import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.03.15
 */
class Indexer(builder: IndexBuilder, dir: File)
  extends ResourceIndexer[IndexShard](builder, dir, WizardIndexing.indexExtension, 20.minutes) {

  Metrics("wizard.indexer").newGauge("builder.size") { builder.size }

  protected var loader: WizardResourceLoader[IndexShard] = IndexShard

  protected def merger: ResourceMerger[IndexShard] = IndexMerger
}
