package ru.yandex.tours.indexer.wizard

import java.io.File

import ru.yandex.tours.index.WizardIndexing.MicroOffers
import ru.yandex.tours.util.Metrics
import ru.yandex.tours.wizard.microoffer.MicroOfferIndexImpl
import ru.yandex.tours.wizard.resource.WizardResourceLoader

import scala.concurrent.duration._

/**
  * Created by asoboll on 06.02.17.
  */
class MicroOfferIndexer(builder: MicroOfferBuilder, dir: File)
  extends ResourceIndexer[MicroOfferIndexImpl](builder, dir, MicroOffers.extension, 20.minutes) {

  Metrics("wizard.microoffer").newGauge("builder.size") { builder.size }

  protected var loader: WizardResourceLoader[MicroOfferIndexImpl] = MicroOfferIndexImpl

  protected def merger: ResourceMerger[MicroOfferIndexImpl] = MicroOfferMerger
}
