package ru.yandex.tours.indexer.wizard

import java.io.File

import ru.yandex.tours.index.WizardIndexing.MicroOffers
import ru.yandex.tours.util.{IO, Logging}
import ru.yandex.tours.wizard.microoffer.{MicroOfferIndex, MicroOfferIndexImpl, MicroOfferWriter, ShardedMicroOfferIndex}

/**
  * Created by asoboll on 13.02.17.
  */
object MicroOfferMerger extends ResourceMerger[MicroOfferIndexImpl] with Logging {

  def merge(shards: Seq[MicroOfferIndexImpl], writer: MicroOfferWriter): Unit = {
    require(shards.nonEmpty, "shard must be non empty")
    log.info(s"Merging ${shards.size} shards")

    val freshness = shards.map(_.freshness).min
    writer.writeHeader(MicroOffers.formatVersion, freshness, -1)

    val microOffers = new ShardedMicroOfferIndex(shards.toVector)
    val distinctHotels = MicroOfferIndex.distinctHotels(microOffers.iterator)

    var i = 0
    for (item <- distinctHotels) {
      writer.writeItem(item)
      i += 1
      if (i % 100000 == 0) {
        log.info(s"Collected $i records")
      }
    }
    log.info(s"Collected $i records")
  }

  def mergeTo(shards: Seq[MicroOfferIndexImpl], files: IndexedSeq[File]): Unit = {
    val writers = files.map(MicroOfferWriter.apply)
    IO.using(MicroOfferWriter(writers)) { shardedWriter =>
      merge(shards, shardedWriter)
    }
  }
}
