package ru.yandex.tours.indexer.wizard

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.vertis.scheduler.model.Schedule.{EveryHours, EveryMinutes}
import ru.yandex.vertis.scheduler.model.{Payload, Task, TaskDescriptor}

import scala.concurrent.duration._

/**
  * Created by asoboll on 14.02.17.
  */
class MicroOfferScheduler(indexer: MicroOfferIndexer,
                          distributor: ResourceDistributor,
                          dataPersistenceManager: DataPersistenceManager)
  extends ResourceScheduler(indexer, distributor, dataPersistenceManager, "microOffers") {

  def freshOffersTask: Task = Task(
    TaskDescriptor("wizard_offers_fresh", EveryMinutes(1), description = Some("Builds fresh micro offers (20m)")),
    Payload.Sync(() => doFreshResource(20.minutes))
  )

  def longOffersTask: Task = Task(
    TaskDescriptor("wizard_offers_long", EveryHours(1), description = Some("Builds long micro offers (24h)")),
    Payload.Sync(() => doLongResource(24.hours, DataTypes.shardedMicroOffers.count, DataTypes.shardedMicroOffers))
  )
}
