package ru.yandex.tours.indexer.wizard

import java.io.OutputStream

import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.{HotelSearchRequest, OfferSearchRequest}

/**
  * Created by asoboll on 01.02.17.
  */
trait ResourceBuilder {

  def hotelIndex: HotelsIndex

  def size: Int

  def write(os: OutputStream): Unit

  def clear(): Unit

  def ++=(hr: HotelSearchRequest, snippets: Seq[HotelSnippet]): Unit

  def ++=(request: OfferSearchRequest, offers: Seq[Offer]): Unit

}
