package ru.yandex.tours.indexer.wizard

import akka.actor.ActorSystem
import org.apache.curator.framework.CuratorFramework
import ru.yandex.common.pusher.PusherExtension
import ru.yandex.tours.util.Monitorings
import ru.yandex.tours.wizard.resource.RawResource

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.03.15
 */
class ResourceDistributor(topic: String, curatorFramework: CuratorFramework, zkPath: String)
                         (implicit akkaSystem: ActorSystem) {

  private val extension = PusherExtension(akkaSystem)
  private val publisher = extension.newPublisher(topic, curatorFramework, zkPath, Monitorings.registry)

  def push(resource: RawResource): Unit = {
    publisher ! resource
  }

}
