package ru.yandex.tours.indexer.wizard

import akka.stream.scaladsl.{Flow, Keep, Sink}
import ru.yandex.tours.events.SearchEvent
import ru.yandex.tours.indexer.data.SearchEventStreams
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.akka.Streams

import scala.concurrent.ExecutionContext

/**
  * Created by asoboll on 17.02.17.
  */
object WizardSearchEventReceiver extends Logging {

  def apply(searchEventStreams: SearchEventStreams)
           (indexers: ResourceIndexer[_]*)
           (implicit ec: ExecutionContext): Unit = {

    def push(searchEvent: SearchEvent): Unit = {
      indexers.foreach(_.push(searchEvent))
    }

    val sink = Flow[Seq[SearchEvent]]
      .via(Streams.flatten)
      .toMat(Sink.foreach(push))(Keep.right)

    searchEventStreams.register("wizard", sink) onComplete {
      res => log.warn(s"SearchEvent stream unexpectedly completed: $res")
    }
  }

}
