package ru.yandex.tours.indexer.wizard.parser

import java.io._

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.indexer.task.{PeriodicUpdatable, TaskWeight}
import ru.yandex.tours.query._
import ru.yandex.tours.query.parser.ParserResources
import ru.yandex.tours.util.IO
import ru.yandex.vertis.scheduler.model.Schedule.EveryMinutes
import ru.yandex.vertis.scheduler.model.{Payload, Task, TaskDescriptor}

import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.10.15
 */
class ParsingTrieTasks(parserResources: ParserResources, dataPersistenceManager: DataPersistenceManager) {

  def buildStopWords(): Unit = {
    val trie = ParsingTrieBuilder.build(Seq(PragmaticRule(StopWord, parserResources.getStopWords)))
    val baos = new ByteArrayOutputStream()
    trie.writeTo(baos)
    dataPersistenceManager.checkAndStore(DataTypes.stopWordsTrie, new ByteArrayInputStream(baos.toByteArray))
  }

  def buildWizardTrie(): Unit = {
    val trie = ParsingTrieBuilder.build(parserResources)
    val file = IO.usingTmp("parsing_trie") { os => trie.writeTo(os) }
    try dataPersistenceManager.checkAndStore(DataTypes.wizardTrie, new FileInputStream(file))
    finally file.delete()
  }

  def buildWizardReqAnsTrie(): Unit = {
    val trie = ParsingTrieBuilder.buildReqAns(parserResources.getReqAns)
    val file = IO.usingTmp("reqans_trie") { os => trie.writeTo(os) }
    try dataPersistenceManager.checkAndStore(DataTypes.wizardReqAnsTrie, new FileInputStream(file))
    finally file.delete()
  }

  def buildStopWordsTask: Task = Task(
    TaskDescriptor("stop_words_trie", EveryMinutes(10), description = Some("ParsingTrie for stop words")),
    Payload.Sync(() => buildStopWords())
  )

  def buildWizardTrieTask: Task = {
    new PeriodicUpdatable(30.minutes, "wizard_trie") with TaskWeight.Unique {
      override def run(): Unit = buildWizardTrie()
    }.asTask
  }

  def buildWizardReqAnsTrieTask: Task = {
    new PeriodicUpdatable(30.minutes, "wizard_reqans_trie") with TaskWeight.Unique {
      override def run(): Unit = buildWizardReqAnsTrie()
    }.asTask
  }

}
