package ru.yandex.tours.parsers.common

import ru.yandex.tours.db.{DBWrapper, HotelStableId, HotelStableIds, Target}
import ru.yandex.tours.model.hotels.Partners.Partner
import slick.driver.MySQLDriver.api._

import scala.concurrent.{ExecutionContext, Future}

class DBStableIds(db: DBWrapper)(implicit ec: ExecutionContext) extends StableIds {
  private val GROUP_SIZE = 1000

  override def getId(partner: Partner, localId: String): Future[Int] = {
    for {
      _ <- HotelStableIds.insertIgnore(db)(partner.id, localId)
      id <- db.run(query(partner, localId).result.head)
    } yield id
  }

  private def query(partner: Partner, localId: String) = {
    for {
      id <- HotelStableIds.table
      if id.partner === partner.id
      if id.partnerId === localId
    } yield id.id
  }

  override def persist(): Future[Unit] = Future.successful {}

  override def getIds(partner: Partner): Future[Iterable[(String, Int)]] = {
    val q = for {
      hsi <- HotelStableIds.table
      if hsi.partner === partner.id
    } yield (hsi.partnerId, hsi.id)
    db.run(q.result)(Target[Effect.Read](isReadOnly = false))
  }

  override def add(partner: Partner, ids: Iterable[String]): Future[Unit] = {
    val (group, tail) = ids.splitAt(GROUP_SIZE)
    insertGroup(partner, group).flatMap { _ =>
      if (tail.nonEmpty) {
        add(partner, tail)
      } else {
        Future.successful {}
      }
    }
  }

  private def insertGroup(partner: Partner, group: Iterable[String]) = {
    val toInsert = group.map(HotelStableId(0, partner, _))
    val q = HotelStableIds.table ++= toInsert
    db.run(q)
  }
}
