package ru.yandex.tours.parsers.common

import ru.yandex.tours.model.hotels.Partners.Partner

import scala.concurrent.{ExecutionContext, Future}

trait StableIds {
  def getId(partner: Partner, localId: String): Future[Int]

  def getIds(partner: Partner): Future[Iterable[(String, Int)]]

  def add(partner: Partner, ids: Iterable[String]): Future[Unit]

  def save(partner: Partner, ids: Iterable[String])
          (implicit ec: ExecutionContext): Future[Unit] = for {
    _ <- add(partner, ids)
    _ <- persist()
  } yield ()

  def persist(): Future[Unit]
}
