package ru.yandex.tours.parsers.lt

import org.json.{JSONArray, JSONObject}
import ru.yandex.tours.util.Logging

import scala.util.Try

object CityParser extends Logging {
  case class Country(id: Int, ruName: String, enName: String)

  case class City(id: Int, ruName: String, country: Country)

  def parseCities(rawJson: String) = Try {
    val array = new JSONArray(rawJson)
    (0 until array.length()).map(i => {
      parseCity(array.getJSONObject(i))
    })
  }

  def parseCity(city: JSONObject) = {
    City(
      city.getInt("id"),
      city.getString("name_ru"),
      parseCountry(city.getJSONObject("country"))
    )
  }

  private def parseCountry(country: JSONObject) = {
    Country(
      country.getInt("id"),
      country.getString("name_ru"),
      country.getString("name_en")
    )
  }
}
