package ru.yandex.tours.parsers.lt

import java.io.File

import org.json.{JSONArray, JSONObject}
import ru.yandex.tours.model.BaseModel.{LangToVal, Point}
import ru.yandex.tours.model.hotels.HotelsHolder._
import ru.yandex.tours.model.hotels.{HotelsHolder, Partners, Star}
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.lang._

import scala.collection.JavaConversions._
import scala.util.Try

object HotelParser extends Logging {

  def parseHotels(tsvInput: File, jsonInput: File, geoMapping: File, startId: Int) = {
    val lines = scala.io.Source.fromFile(tsvInput).getLines()
    val headers = lines.next().split("\t")
    val city2geoId = scala.io.Source.fromFile(geoMapping).getLines().toIterable.tail.flatMap(line => {
      val parts = line.split("\t")
      if (parts(3).nonEmpty) {
        Some(parts(3) -> parts(0).toInt)
      } else {
        None
      }
    }).toMap
    val jsonHotels = new JSONArray(scala.io.Source.fromFile(jsonInput).getLines().mkString)
    var cnt = 0
    var totalParsedHotels = 0
    val result = lines.toSeq.zip((0 until jsonHotels.length()).map(jsonHotels.getJSONObject)).flatMap({
      case (line, jsonObject) =>
        totalParsedHotels += 1
        val tryHotel = parseHotel(line, jsonObject, city2geoId, startId + totalParsedHotels)
        tryHotel onFailure {
          e =>
            cnt += 1
            println("can not parse hotel! " + e.getMessage)
        }
        tryHotel.toOption
    })
    result.toArray
    println(s"$cnt hotels failed to parse. Total parsed: $totalParsedHotels")
    result
  }

  private def parseHotel(line: String, jsonObject: JSONObject, city2geoId: Map[String, Int], id: Int): Try[Hotel] = Try {
    val parts = line.split("\t")
    val address = Address.newBuilder()
      .setLang("ru")
      .setCountry(parts(2))
      .setLocality(parts(3))
      .setFullAddress(parts(5))
    val point = Point.newBuilder()
      .setLatitude(parts(8).toDouble)
      .setLongitude(parts(7).toDouble)
    val geoId = city2geoId.getOrElse(parts(96), throw new Exception(s"No known geoId for city with id ${parts(96)}"))
    val imagesArray = jsonObject.getJSONArray("images")
    val images = (0 until imagesArray.length()).flatMap(i => Try(imagesArray.getJSONObject(i).getString("original")).toOption).map(url => "http://level.travel/s3/" + url)
    val result = HotelsHolder.Hotel.newBuilder()
      .setPartnerId(Partners.lt.id)
      .setLocalId(parts(0))
      .addName(LangToVal.newBuilder().setLang("ru").setValue(parts(1)))
      .addAddress(address)
      .setPoint(point)
      .setStars(Star.getStar(parts(11)).id)
      .setPartnerUrl(parts(9))
      .addAllPhotos(asJavaIterable(images))
      .setId(id)
      .setGeoId(geoId)
    Try(jsonObject.getDouble("rating")).foreach(result.setRating)
    val setter = addFeature(result)(_)
    nonEmpty(parts(95))(result.setHotelUrl)
    nonEmpty(parts(6))(result.addPhone)
    nonEmpty(parts(12))(setter("build_year"))
    nonEmpty(parts(13))(setter("reconstruct_year"))
    nonEmpty(parts(14))(setter("room_number"))
    nonEmpty(parts(15))(setter("distance_to_beach"))
    nonEmpty(parts(16))(setter("beach_size"))
    nonEmpty(parts(17))(t => setter("distance_to_aeroport")((t.replace(',', '.').toDouble * 1000).toInt.toString))
    nonEmpty(parts(19))(setter("territory_size"))
    nonEmpty(parts(20))(_ => setter("pets")("true"))
    nonEmpty(parts(21))(_ => setter("type_parking")("paid_parking"))
    nonEmpty(parts(22))(_ => setter("type_parking")("free_parking"))
    nonEmpty(parts(95))(result.setHotelUrl)
//    nonEmpty(parts(23))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(24))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(25))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(26))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(27))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(28))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(29))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(30))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(31))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(32))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(33))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(34))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(35))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(36))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(37))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(38))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(39))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(40))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(41))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(42))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(43))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(44))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(45))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(46))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(47))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(48))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(49))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(50))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(51))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(52))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(53))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(54))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(55))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(56))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(57))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(58))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(59))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(60))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(61))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(62))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(63))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(64))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(65))(_ => setter("room_disabled")("true"))
//    nonEmpty(parts(66))(_ => setter("room_disabled")("true"))
    result.build()
  }

  private def addFeature(builder: Hotel.Builder)(name: String)(value: String) = {
    builder.addFeatures(Feature.newBuilder().setName(name).setValue(value))
  }

  private def nonEmpty(x: String)(f: String => Any): Unit = {
    if (!x.isEmpty) {
      f(x)
    }
  }
}
