package ru.yandex.tours.stat

import org.joda.time.LocalDate
import ru.yandex.tours.hotels.{HotelsIndex, HotelsVideo}
import ru.yandex.tours.util.lang.Futures._
import ru.yandex.tours.util.parsing.TSKV

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 09.03.16
 */
class HotelStatsExport(specstatClient: SpecstatClient,
                       hotelsIndex: HotelsIndex,
                       hotelsVideo: HotelsVideo)
                      (implicit ec: ExecutionContext)
  extends PeriodicStatsExporter("hotels_stats") {

  override def run: Future[_] = Future {
    var total = 0
    var withRating = 0
    var withReviews = 0
    var withVideo = 0
    var reviews = 0

    hotelsIndex.hotels.foreach { hotel =>
      total += 1
      if (hotel.rating > 0d) withRating += 1
      if (hotel.reviewsCount > 0) withReviews += 1
      reviews += hotel.reviewsCount
      if (hotelsVideo.getVideo(hotel).nonEmpty) withVideo += 1
    }

    val tskv = TSKV(Seq(
      "fielddate" -> LocalDate.now().toString,
      "count" -> total,
      "hidden" → (hotelsIndex.size - total),
      "with_rating" -> withRating,
      "with_reviews" -> withReviews,
      "with_video" -> withVideo,
      "reviews" -> reviews
    ))
    specstatClient.post("Travel/Hotels/Stat/daily", tskv, 1.hour)
  }.flatten
}
