package ru.yandex.tours.stat

import ru.yandex.tours.util.lang.Futures._
import ru.yandex.vertis.scheduler.model.{Payload, Schedule, Task, TaskDescriptor}

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 09.03.16
 */
abstract class PeriodicStatsExporter(name: String) {

  def run: Future[_]

  def asTask(schedule: Schedule): Task = Task(
    TaskDescriptor(name, schedule),
    Payload.Async(() => run.toUnit)
  )
}
