package ru.yandex.tours.stat

import ru.yandex.tours.app._
import ru.yandex.tours.db.{HotelsDbSupport, MySqlSupport}
import ru.yandex.vertis.scheduler.model.Schedule.{AtFixedHourOfDay, Manually}
import ru.yandex.vertis.scheduler.model.{Schedule, Task}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 09.03.16
 */
trait StatsExportSupport extends SchedulerTasks {
  app: Application
    with AkkaSupport
    with HttpSupport
    with MySqlSupport
    with CommonDataHolders
    with HotelsDbSupport =>

  import akkaSystem.dispatcher

  val specstatClient = new SpecstatClient(httpClient, app.config.getString("specstat.host"))(dispatcher)

  private def schedule(original: Schedule, isProductionReady: Boolean): Schedule = {
    if (app.isEnvironmentStable ^ isProductionReady) Manually
    else original
  }

  val hotelStatsExport = new HotelStatsExport(specstatClient, hotelsIndex, hotelsVideo)
  val hotelUpdateStatsExport = new HotelUpdateStatsExport(hotelsDao, specstatClient)

  override def schedulingTasks: Seq[Task] = {
    super.schedulingTasks ++ Seq(
      hotelStatsExport.asTask(schedule(AtFixedHourOfDay(3), isProductionReady = true)),
      hotelUpdateStatsExport.asTask(schedule(AtFixedHourOfDay(2), isProductionReady = true))
    )
  }
}
