package ru.yandex.tours.model

import ru.yandex.tours.model.BaseModel.LangToVal
import ru.yandex.tours.model.Languages.Lang

import scala.util.Try

object LocalizedString {
  def apply(strings: (Lang, String)*): LocalizedString = {
    val map = strings.groupBy(_._1).mapValues(_.head._2).map(identity)
    new LocalizedString(map)
  }

  def fromMap(map: Map[String, String]): LocalizedString = new LocalizedString({
    for {
      (rawLang, value) <- map
      lang <- Try(Languages.withName(rawLang)).toOption
    } yield lang -> value
  })

  def fromLangToVal(x: Iterable[LangToVal]): LocalizedString = {
    val lang2val = x.toSeq.flatMap(t => Try(Languages.withName(t.getLang)).toOption.map(_ -> t.getValue))
    LocalizedString(lang2val: _*)
  }

  def empty: LocalizedString = LocalizedString()
}

case class LocalizedString(values: Map[Lang, String]) {
  def apply(lang: Lang): String = {
    values.get(lang)
      .orElse(values.get(Languages.ru))
      .orElse(values.get(Languages.en))
      .getOrElse(values.headOption.map(_._2).getOrElse(""))
  }

  def get(lang: Lang): Option[String] = values.get(lang)

  def ruName: String = apply(Languages.ru)
  def allValues: List[String] = values.values.toList
  def isEmpty: Boolean = values.isEmpty
  final def nonEmpty: Boolean = !isEmpty
}
