package ru.yandex.tours.model

/* @author berkut@yandex-team.ru */

object RequestStatus extends Enumeration {
  type RequestStatus = RequestStatus.Value
  val PENDING, PERFORMING, COMPLETED, CACHED, NO_RESULTS, ALL_FILTERED, WARMING, SKIPPED, FAILED, PARTNER_FAILED, PARTNER_TIMEOUT, UNKNOWN = Value

//  def isSuccessful(x: RequestStatus) = x == RequestStatus.COMPLETED || x == RequestStatus.CACHED || x == RequestStatus.WARMING

  def isFinished(x: RequestStatus) = !(x == PENDING || x == PERFORMING)

  def isFailed(x: RequestStatus) = x == FAILED || x == PARTNER_FAILED || x == PARTNER_TIMEOUT || x == UNKNOWN
}
