package ru.yandex.tours.model

import ru.yandex.tours.model.hotels.Partners._

sealed trait Source {
  def id: Int
  def name: String
  def code: String
  def partner2id: Map[Partner, String]
  def priority: Double

  def partners: Set[Partner] = partner2id.keySet

  def contains(partner: Partner): Boolean = partner2id.contains(partner)
  def exists(predicate: Partner ⇒ Boolean): Boolean = partner2id.exists(p ⇒ predicate(p._1))
  def mappingFor(partner: Partner): Seq[String] = partner2id.get(partner).toSeq

  override def toString: String = s"${getClass.getSimpleName.take(1)}{$id, $name}"
}

// Same fields, but different classes. It's done for strong types

case class HotelProvider(id: Int, partner2id: Map[Partner, String],
                         name: String, code: String, priority: Double) extends Source

case class TourOperator(id: Int, partner2id: Map[Partner, String],
                        name: String, code: String, priority: Double) extends Source