package ru.yandex.tours.model.direction

import Thematics._
import ru.yandex.tours.model.Seasonality
import org.apache.commons.lang.StringUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 07.07.15
 */
case class ThematicInfo(thematic: Thematic, relevance: Double, season: Seasonality, highSeason: Seasonality) {
  require(relevance >= 0 && relevance <= 10, "relevance must be in range [0;10]")
}

object ThematicInfo {
  def parse(string: String): ThematicInfo = {
    StringUtils.splitPreserveAllTokens(string, ':') match {
      case Array(thematic, relevance, season, highSeason) =>
        ThematicInfo(
          Thematics.withName(thematic),
          relevance.toDouble,
          Seasonality.parse(season),
          Seasonality.parse(highSeason)
        )
    }
  }

  def serialize(thematicInfo: ThematicInfo): String = {
    import thematicInfo._
    s"$thematic:$relevance:${Seasonality.serialize(season)}:${Seasonality.serialize(highSeason)}"
  }
}