package ru.yandex.tours.model.filter

trait Filter {
  def name: String
  def values: Seq[FilterableValue]
  def isEmpty: Boolean = values.isEmpty
  final def nonEmpty: Boolean = !isEmpty

  def prettyString: String = name + ": " + values.map {
    case StringValue(x) => x
    case IntValue(x) => x.toString
    case BooleanValue(x) => x.toString
    case DoubleValue(x) => x.toString
    case NullValue => "null"
  }.sorted.mkString(",")
}
