package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{BooleanValue, FilterableValue, HotelFilter}
import ru.yandex.tours.model.hotels.Features.BooleanFeature

case class BooleanFeatureFilter(feature: BooleanFeature, value: Option[BooleanValue]) extends HotelFilter {
  override def name: String = feature.name
  override def values: Seq[FilterableValue] = value.toSeq

  override def prettyString: String = name + ": " + value.fold("none")(_.x.toString)
}
