package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{IntValue, FilterableValue, HotelFilter}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.09.15
 */
class GeoIdFilter(geoIds: Seq[Int]) extends HotelFilter {
  def this(geoId: Int) = this(Seq(geoId))
  override def name: String = GeoIdFilter.name
  override def values: Seq[FilterableValue] = geoIds.map(IntValue)
}

object GeoIdFilter {
  def name: String = "geo_id"
  def apply(id: Int): GeoIdFilter = new GeoIdFilter(id)
}