package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{StringValue, FilterableValue, HotelFilter}
import ru.yandex.tours.model.hotels.HotelsHolder.HotelType

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.10.15
 */
case class HotelTypeFilter(values: Seq[FilterableValue]) extends HotelFilter {
  override def name: String = HotelTypeFilter.name
}

object HotelTypeFilter {
  def name: String = "hotel_type"

  def apply(types: Set[HotelType]): HotelTypeFilter =
    new HotelTypeFilter((types - HotelType.UNKNOWN).map(HotelTypeFilter.toFilterableValue).toSeq)

  def construct(types: Seq[HotelType]): HotelTypeFilter = apply(types.toSet)

  def toFilterableValue(`type`: HotelType): StringValue = StringValue(`type`.name().toLowerCase)
}