package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{FilterableValue, HotelFilter, IntValue}

/**
  * Created by Evgeny Zhoga on 21.01.16.
  */
class PartnerIdFilter(partnerIds: Seq[Int]) extends HotelFilter {
  def this(partnerId: Int) = this(Seq(partnerId))

  override def name: String = PartnerIdFilter.name

  override def values: Seq[FilterableValue] = partnerIds.map(IntValue)
}

object PartnerIdFilter {
  def name: String = "partner_id"

  def apply(id: Int): PartnerIdFilter = new PartnerIdFilter(id)
}