package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{FilterableValue, HotelFilter, IntValue}
import ru.yandex.tours.model.search.SearchType.SearchType

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.10.15
 */
case class SearchTypeFilter(searchTypes: SearchType*) extends HotelFilter {
  override def name: String = SearchTypeFilter.name
  override def values: Seq[FilterableValue] = searchTypes.map(st => IntValue(st.id))

  override def prettyString: String = "context: " + searchTypes.mkString(", ")
}

object SearchTypeFilter {
  def name = "st"
}