package ru.yandex.tours.model.filter.hotel

import ru.yandex.tours.model.filter.{HotelFilter, StringValue}

case class StarFilter(values: Seq[StringValue]) extends HotelFilter {
  def this(values: Set[Int]) = this(values.map(v => StringValue.apply(v.toString)).toSeq)

  override def name: String = StarFilter.name
}

object StarFilter {
  val name = "stars"
}