package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.filter.{SnippetFilter, StringValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}

import scala.collection.JavaConversions._

/**
  * Created by asoboll on 03.03.17.
  */
case class ExcludePartnerFilter(override val name: String, partners: Set[Int]) extends SnippetFilter {

  override def fits(offer: Offer): Boolean = partners.isEmpty || !partners.contains(offer.getSource.getPartnerId)

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = {
    if (fits(snippet)) Some(snippet)
    else None
  }

  override def fits(snippet: HotelSnippet): Boolean = {
    partners.isEmpty ||
    !snippet.getSourceList.map(_.getPartnerId).exists(partners.contains)
  }

  override def values: Seq[StringValue] = partners.map(_.toString).map(StringValue).toSeq
}
