package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.filter.{SnippetFilter, StringValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}

case class ExcludeTourByIdFilter(ids: Set[String]) extends SnippetFilter {
  override def name: String = ExcludeTourByIdFilter.name

  override def fits(offer: Offer): Boolean = !ids.contains(offer.getId)

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = Some(snippet)

  override def fits(snippet: HotelSnippet): Boolean = true

  override def values: Seq[StringValue] = ids.map(StringValue).toSeq
}

object ExcludeTourByIdFilter {
  val name = "exclude_id"
}