package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.filter.{IntValue, SnippetFilter}

case class HotelIdFilter(hotelId: Option[Int]) extends SnippetFilter {
  override def name: String = HotelIdFilter.name

  override def fits(offer: Offer): Boolean = hotelId.isEmpty || hotelId.get == offer.getHotelId

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = if (fits(snippet)) Some(snippet) else None

  override def fits(snippet: HotelSnippet): Boolean = hotelId.isEmpty || hotelId.get == snippet.getHotelId

  override def values: Seq[IntValue] = hotelId.map(IntValue).toSeq
}

object HotelIdFilter {
  val name = "hotel_id"
}