package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.BaseModel.Pansion
import ru.yandex.tours.model.filter.{FilterableValue, SnippetFilter, StringValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}

import scala.collection.JavaConversions._

case class PansionFilter(pansions: Set[Pansion]) extends SnippetFilter {
  override def name: String = PansionFilter.name

  override def fits(offer: Offer): Boolean = pansions.isEmpty || pansions.contains(offer.getPansion)

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = {
    if (pansions.isEmpty) {
      Option(snippet)
    } else {
      val newPansions = snippet.getPansionsList.filter(t => pansions.contains(t.getPansion))
      if (newPansions.isEmpty) {
        None
      } else {
        val amended = snippet.toBuilder
          .clearPansions()
          .addAllPansions(newPansions)
          .setPriceMin(newPansions.map(_.getPrice).min)
          .build()
        Option(amended)
      }
    }
  }

  override def fits(snippet: HotelSnippet): Boolean =
    pansions.isEmpty || snippet.getPansionsList.map(_.getPansion).exists(pansions.contains)

  override def values: Seq[FilterableValue] = pansions.map(_.toString.toLowerCase).map(StringValue).toSeq
}

object PansionFilter {
  val name = "pansions"
}