package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.filter.{FilterableValue, IntValue, NullValue, SnippetFilter}

import scala.collection.JavaConversions._

case class PriceFilter(from: Option[Int] = None, to: Option[Int] = None) extends SnippetFilter {
  override def name: String = PriceFilter.name

  override def fits(offer: Offer): Boolean = (from.isEmpty || offer.getPrice >= from.get) && (to.isEmpty || offer.getPrice <= to.get)

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = {
    if (from.isEmpty && to.isEmpty) {
      Option(snippet)
    } else {
      val newPansions = snippet.getPansionsList.filter(fits)
      if (newPansions.isEmpty) {
        None
      } else {
        val amended = snippet.toBuilder
          .clearPansions()
          .addAllPansions(newPansions)
          .setPriceMin(newPansions.map(_.getPrice).min)
          .build()
        Option(amended)
      }
    }
  }

  private def fits(pansion: HotelSnippet.PricedPansion): Boolean = {
    (from.isEmpty || pansion.getPrice >= from.get) && (to.isEmpty || pansion.getPrice <= to.get)
  }

  override def fits(snippet: HotelSnippet): Boolean = snippet.getPansionsList.exists(fits)

  override def values: Seq[FilterableValue] = Seq(getAsFilterable(from), getAsFilterable(to))

  private def getAsFilterable(x: Option[Int]) = x.map(IntValue).getOrElse(NullValue)

  override def isEmpty: Boolean = from.isEmpty && to.isEmpty

  override def prettyString: String = Seq(
    from.map(p => s"от $p р."),
    to.map(p => s"до $p р.")
  ).flatten.mkString(" ")
}

object PriceFilter {
  val name = "price"
}