package ru.yandex.tours.model.filter.snippet

import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.filter.{StringValue, SnippetFilter}
import scala.collection.JavaConversions._

case class SearchSourceFilter(override val name: String, operators: Set[Int]) extends SnippetFilter {

  override def fits(offer: Offer): Boolean = operators.isEmpty || operators.contains(offer.getSource.getOperatorId)

  override def amendIfFits(snippet: HotelSnippet): Option[HotelSnippet] = if (operators.isEmpty) {
    Some(snippet)
  } else {
    if (snippet.getSourceList.map(_.getOperatorId).exists(operators.contains)) {
      Some(snippet)
    } else {
      None
    }
  }

  override def fits(snippet: HotelSnippet): Boolean = operators.isEmpty || snippet.getSourceList.map(_.getOperatorId).exists(operators.contains)

  //Guys from ui asked to make tour_operator as string
  override def values: Seq[StringValue] = operators.map(_.toString).map(StringValue).toSeq

  override def prettyString = name + ": " + operators.toSeq.sorted.map(_.toString).mkString(",")
}