package ru.yandex.tours.model.geo

import ru.yandex.tours.model.BaseModel.Point

trait MapObject {
  def longitude: Double
  def latitude: Double
}

object MapObject {
  import scala.language.implicitConversions

  implicit def fromPoint(point: Point): MapObject = new MapObject {
    override def latitude: Double = point.getLatitude
    override def longitude: Double = point.getLongitude
  }
}